﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkStaticOptions : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }

            string[] expectedOptions = null;
            switch (conf.ProjectType)
            {
                case ProjectType.Library:
                    // don't care
                    break;
                case ProjectType.DynamicLibrary:
                    expectedOptions = new[]
                    {
                        "-nostartfiles",
                        "-Wl,--gc-sections",
                        "-Wl,-init=_init,-fini=_fini",
                        "-Wl,-shared",
                        "-Wl,--whole-archive",
                        "-Wl,-z,combreloc,-z,relro,--enable-new-dtags",
                    };
                    break;
                case ProjectType.Program:
                    expectedOptions = new[]
                    {
                        "-nostartfiles",
                        "-Wl,--gc-sections",
                        "-Wl,-init=_init,-fini=_fini",
                        "-Wl,-pie",
                        "-Wl,-z,combreloc,-z,relro,--enable-new-dtags",
                    };
                    break;
                case ProjectType.ProgramWithoutSdkNso:
                    expectedOptions = new[]
                    {
                        "-nostartfiles",
                        "-Wl,--gc-sections",
                        "-Wl,-init=_init,-fini=_fini",
                        "-Wl,-pie",
                        "-Wl,-z,combreloc,-z,relro,--enable-new-dtags",
                    };
                    break;
                case ProjectType.SystemProgram:
                    expectedOptions = new[]
                    {
                        "-nostartfiles",
                        "-Wl,--gc-sections",
                        "-Wl,-init=_init,-fini=_fini",
                        "-Wl,-pie",
                        "-Wl,-e,_start",
                    };
                    break;
                default:
                    Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                    break;
            }

            if (expectedOptions == null)
            {
                return;
            }

            var expectedOptionsFor32bit = new[] { "-Wl,--target2=got-rel" };
            switch (conf.Platform)
            {
                case "NX32":
                    AssertUtil.AssertOrderedSequenceEqual(
                        Util.TokenizeCommandLineOptions(ep.Metadata["Link.StaticOptions"]),
                        expectedOptions.Concat(expectedOptionsFor32bit));
                    break;
                case "NX64":
                    AssertUtil.AssertOrderedSequenceEqual(
                        Util.TokenizeCommandLineOptions(ep.Metadata["Link.StaticOptions"]),
                        expectedOptions);
                    break;
                default:
                    Assert.True(false, string.Format($"予期しない NX 開発機環境のプラットフォームです: {conf.Platform}"));
                    break;
            }
        }
    }
}
