﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkOptimizeReferences : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsWinPlatform)
            {
                return;
            }

            switch (conf.BuildType)
            {
                case "Debug":
                case "Develop":
                    Assert.Equal("false", Util.GetValueOrDefault(ep.Metadata, "Link.OptimizeReferences", "false"));
                    break;
                case "Release":
                    Assert.Equal("true", Util.GetValueOrDefault(ep.Metadata, "Link.OptimizeReferences", "false"));
                    break;
                default:
                    Assert.True(false, string.Format("未知の BuildType です: {0}", conf.BuildType));
                    break;
            }
        }
    }
}
