﻿using System.Linq;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkAdditionalOptions : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (conf.ProjectType == ProjectType.Library)
            {
                return;
            }

            switch (conf.Platform)
            {
                case "Win32":
                case "x64":
                    InvokeWinPlatformAssertions(conf, ep, expander);
                    break;
                case "NX32":
                case "NX64":
                    InvokeNXPlatformAssertions(conf, ep, expander);
                    break;
                default:
                    Assert.True(false, string.Format("未知の Platform です: {0}", conf.Platform));
                    break;
            }
        }

        private void InvokeWinPlatformAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            Assert.Equal(string.Empty, Util.GetValueOrDefault(ep.Metadata, "Link.AdditionalOptions", string.Empty));
        }

        private void InvokeNXPlatformAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.ProjectType)
            {
                case ProjectType.Library:
                    // don't care
                    break;
                case ProjectType.DynamicLibrary:
                case ProjectType.SystemProgram:
                    AssertUtil.AssertSequenceEqual(
                        Util.TokenizeCommandLineOptions(Util.GetValueOrDefault(ep.Metadata, "Link.AdditionalOptions", string.Empty)),
                        Enumerable.Empty<string>());
                    break;
                case ProjectType.Program:
                case ProjectType.ProgramWithoutSdkNso:
                    switch (conf.SubRootName)
                    {
                        case "Alice":
                        case "Chris":
                        case "Eris":
                        case "Iris":
                        case "NintendoWare":
                        case "Tests":
                        case "Samples":
                        case "Users":
                            AssertUtil.AssertOrderedSequenceEqual(
                                Util.TokenizeCommandLineOptions(ep.Metadata["Link.AdditionalOptions"]),
                                new[] { "-Wl,-u,malloc", "-Wl,-u,calloc", "-Wl,-u,realloc", "-Wl,-u,aligned_alloc", "-Wl,-u,free" });
                            break;
                        default:
                            Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                            break;
                    }
                    break;
                default:
                    Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                    break;
            }
        }
    }
}
