﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LibAdditionalOptions : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (conf.ProjectType == ProjectType.Program)
            {
                return;
            }

            switch (conf.Platform)
            {
                case "Win32":
                case "x64":
                    if (conf.SubRootName != "Tests")  // FIXME: 区別する必要ないのでは
                    {
                        AssertUtil.AssertSequenceContainsElements(
                            Util.TokenizeCommandLineOptions(ep.Metadata["Lib.AdditionalOptions"]),
                            new[] { "/ignore:4221" });
                    }
                    break;
                case "NX32":
                case "NX64":
                    break;
                default:
                    Assert.True(false, string.Format($"未知の Platform です: {conf.Platform}"));
                    break;
            }
        }
    }
}
