﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class ClCompileOptimization : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsWinPlatform)
            {
                return;
            }

            switch (conf.BuildType)
            {
                case "Debug":
                    AssertMsBuildValueContainsElements(expander,
                        ep.Metadata["ClCompile.Optimization"],
                        "Disabled");
                    break;
                case "Develop":
                case "Release":
                    AssertMsBuildValueContainsElements(expander,
                        ep.Metadata["ClCompile.Optimization"],
                        "MaxSpeed");
                    break;
                default:
                    Assert.True(false, string.Format("未知の BuildType です: {0}", conf.BuildType));
                    break;
            }
        }
    }
}
