﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PropertySheetsTest
{
    /// <summary>
    /// パスとしての一致比較を行います。すなわち、以下の違いを無視した文字列の一致比較を行います。
    /// * ディレクトリ区切り文字の違い (\ or /)
    /// * ディレクトリ区切り文字の重複
    /// * ディレクトリ区切り文字で終端されているか否か
    /// * 大文字、小文字の別
    /// </summary>
    internal class PathComparer : IComparer<string>, IEqualityComparer<string>
    {
        private static readonly StringComparer pathStringComparer
            = StringComparer.Create(System.Globalization.CultureInfo.CurrentCulture, true);

        public static PathComparer Default { get; } = new PathComparer();

        public bool Equals(string x, string y)
        {
            return Enumerable.SequenceEqual(Util.SplitPathReversed(x), Util.SplitPathReversed(y), pathStringComparer);
        }

        public int GetHashCode(string obj)
        {
            return string.Join(@"\", Util.SplitPathReversed(obj).ToArray()).GetHashCode();
        }

        public int Compare(string x, string y)
        {
            var xlist = Util.SplitPath(x);
            var ylist = Util.SplitPath(y);

            for (int i = 0; ; i++)
            {
                if (xlist.Count() == ylist.Count())
                {
                    return 0;
                }
                else if (xlist.Count() == i)
                {
                    return -1;
                }
                else if (ylist.Count() == i)
                {
                    return 1;
                }
                else
                {
                    var c = string.Compare(xlist.ElementAt(i), ylist.ElementAt(i), true);

                    if (c != 0)
                    {
                        return c;
                    }
                }
            }
        }
    }
}
