﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/



#include "testAudio_Effect.h"

#include "../../Programs/Eris/Sources/Libraries/audio/audio_AuxTypes.h"
#include "../../Programs/Eris/Sources/Libraries/audio/audio_EffectManager.h"
#include "../../Programs/Eris/Sources/Libraries/audio/audio_AuxBufferApi.h"
#include "../../Programs/Eris/Sources/Libraries/audio/dsp/audio_AuxBufferDsp.h"
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/nn_TimeSpan.h>
#include <nn/util/util_BitUtil.h>
#include <nn/audio/audio_AudioRendererApi-os.win32.h>

#include <limits> // std::numeric_limits


namespace nnt {
namespace audio {

TEST(TestGetRequiredBufferSizeForAux, Success)
{
    nn::audio::AudioRendererParameter pParam = nnt::audio::util::GetAudioRendererParameterForDefault();
    int32_t sampleCount = pParam.sampleCount;
    int channelCount = 2;
    int frameCount = 10;
    size_t expectedSize = nn::util::align_up(sampleCount * frameCount * channelCount * sizeof(int32_t), nn::audio::BufferAlignSize)
                          + nn::util::align_up(sizeof(nn::audio::AuxInfoCpu), nn::audio::BufferAlignSize)
                          + nn::util::align_up(sizeof(nn::audio::AuxInfoDsp), nn::audio::BufferAlignSize);
    EXPECT_EQ(nn::audio::GetRequiredBufferSizeForAuxSendReturnBuffer(&pParam, frameCount, channelCount), expectedSize);
}


#if !defined(NN_SDK_BUILD_RELEASE)
TEST(TestFinalizeAuxBuffer, Precondition)
{
    nn::audio::AuxBufferInfo* auxInfo = nullptr;
    EXPECT_DEATH_IF_SUPPORTED(nn::audio::FinalizeAuxBuffer(auxInfo), "");
}
#endif  // !defined(NN_SDK_BUILD_RELEASE)


} // namespace audio
} // namespace nnt
