﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <limits>
#include <random>

#include "../../Programs/Eris/Sources/Libraries/audio/dsp/audio_BiquadFilter.h"

#if defined(__ARM_NEON__) || defined(__ARM_NEON)
namespace generic {

#include "../../Programs/Eris/Sources/Libraries/audio/dsp/detail/audio_BiquadFilter.generic.h"

}  // namespace negeric

namespace neon {

#include "../../Programs/Eris/Sources/Libraries/audio/dsp/detail/audio_BiquadFilter.neon.h"

}  // namespace neon

TEST(DspBiquadFilter, CompareGenericAndNeon)
{
    const int SampleCount = 1024;
    int32_t input[SampleCount];
    int32_t output0[SampleCount] = { 0 };
    int32_t output1[SampleCount] = { 0 };

    std::mt19937 mt(0);
    const auto a = std::numeric_limits<uint16_t>::max();
    const auto b = std::numeric_limits<int16_t>::min();
    for (auto i = 0; i < SampleCount; ++i)
    {
        input[i] = (mt() % a) + b;
    }
    int16_t numerator[3];
    int16_t denominator[2];
    int64_t state0[2] = { 0 };
    int64_t state1[2] = { 0 };
    for (auto& num : numerator)
    {
        num = (mt() % a) + b;
    }
    for (auto& den : denominator)
    {
        den = (mt() % a) + b;
    }

    for (auto i = 0; i < 16; ++i)
    {
        generic::nn::audio::dsp::detail::ApplyBiquadFilter(output0, input, numerator, denominator, state0, SampleCount);
        neon::nn::audio::dsp::detail::ApplyBiquadFilter(output1, input, numerator, denominator, state1, SampleCount);
        for (auto i = 0; i < SampleCount; ++i)
        {
            EXPECT_EQ(output0[i], output1[i]);
        }
    }
}
#endif  // defined(__ARM_NEON__) || defined(__ARM_NEON)
