﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/audio.h>
#include <nn/nn_Log.h>

/**
 * @brief       This test outputs the size of work buffers for AudioRenderer
 *              (This is for plotting the information on CI infrastructure)
 */
TEST(AudioRenderer, MemoryStatistics)
{
    nn::audio::AudioRendererParameter parameter;
    nn::audio::InitializeAudioRendererParameter(&parameter);

    parameter.sampleRate = 48000;
    parameter.sampleCount = 240;
    parameter.mixBufferCount = 30;
    parameter.subMixCount = 16;
    parameter.voiceCount = 96;
    parameter.sinkCount = 4;
    parameter.effectCount = 32;
    parameter.performanceFrameCount = 16;

    NN_LOG(
        "##teamcity[buildStatisticValue key='MemoryStatistics:AudioRendererWorkBufferSize' value='%d']\n",
        nn::audio::GetAudioRendererWorkBufferSize(parameter)
    );
    NN_LOG(
        "##teamcity[buildStatisticValue key='MemoryStatistics:AudioRendererConfigWorkBufferSize' value='%d']\n",
        nn::audio::GetAudioRendererConfigWorkBufferSize(parameter)
    );
}
