﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/settings/system/settings_Region.h>
#include <nnt/nntest.h>

//!< リージョンコードを取得可能か
TEST(RegionSuite, RegionCodeTest1)
{
    auto code = ::nn::settings::system::RegionCode();

    ::nn::settings::system::GetRegionCode(&code);
}

//!< リージョンコードを取得可能か
TEST(RegionSuite, RegionCodeTest2)
{
    const ::nn::settings::system::RegionCode
        regionA = ::nn::settings::system::RegionCode_Europe;

    const ::nn::settings::system::RegionCode
        regionB = ::nn::settings::system::RegionCode_Usa;

    ::nn::settings::system::SetRegionCode(regionA);

    auto code = ::nn::settings::system::RegionCode();

    ::nn::settings::system::GetRegionCode(&code);

    EXPECT_EQ(regionA, code);

    ::nn::settings::system::SetRegionCode(regionB);

    ::nn::settings::system::GetRegionCode(&code);

    EXPECT_EQ(regionB, code);

    ::nn::settings::system::SetRegionCode(regionA);

    ::nn::settings::system::GetRegionCode(&code);

    EXPECT_EQ(regionA, code);
}
