﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/settings/system/settings_OnlineStorage.h>
#include <nnt/nntest.h>

namespace {

//!< テスト用アカウント毎のオンラインストレージ設定 A
const ::nn::settings::system::AccountOnlineStorageSettings
    AccountOnlineStorageSettingsA =
{
    { { 1, 2 } },
    { { 0x0101 } },
};

//!< テスト用アカウント毎のオンラインストレージ設定 B
const ::nn::settings::system::AccountOnlineStorageSettings
    AccountOnlineStorageSettingsB =
{
    { { 3, 4 } },
    { { 0x0002 } },
};

::nn::settings::system::AccountOnlineStorageSettings
    g_AccountOnlineStorageSettings[
        ::nn::settings::system::AccountOnlineStorageSettingsCountMax];

//!< アカウント毎のオンラインストレージ設定が等しいことを期待します。
void ExpectEqualAccountOnlineStorageSettings(
    const ::nn::settings::system::AccountOnlineStorageSettings& lhs,
    const ::nn::settings::system::AccountOnlineStorageSettings& rhs
    ) NN_NOEXCEPT;

} // namespace

//!< アカウント毎のオンラインストレージ設定を設定可能か
TEST(OnlineStorageSuite, AccountOnlineStorageSettingsTest1)
{
    ::nn::settings::system::SetAccountOnlineStorageSettings(
        &AccountOnlineStorageSettingsA, 1);

    ::nn::settings::system::AccountOnlineStorageSettings* settings =
          &g_AccountOnlineStorageSettings[0];

    const auto countMax =
        ::nn::settings::system::AccountOnlineStorageSettingsCountMax;

    EXPECT_EQ(
        1,
        ::nn::settings::system::GetAccountOnlineStorageSettings(
            settings, countMax));

    {
        SCOPED_TRACE("");
        ExpectEqualAccountOnlineStorageSettings(
            AccountOnlineStorageSettingsA, settings[0]);
    }

    for (size_t i = 0; i < countMax; ++i)
    {
        settings[i] = (i % 2 == 1) ? AccountOnlineStorageSettingsA
                                   : AccountOnlineStorageSettingsB;
    }

    ::nn::settings::system::SetAccountOnlineStorageSettings(settings, countMax);

    for (size_t i = 0; i < countMax; ++i)
    {
        settings[i] = ::nn::settings::system::AccountOnlineStorageSettings();
    }

    EXPECT_EQ(
        countMax,
        ::nn::settings::system::GetAccountOnlineStorageSettings(
            settings, countMax));

    for (size_t i = 0; i < countMax; ++i)
    {
        SCOPED_TRACE("");
        ExpectEqualAccountOnlineStorageSettings(
            (i % 2 == 1) ? AccountOnlineStorageSettingsA
                         : AccountOnlineStorageSettingsB,
            settings[i]);
    }

    ::nn::settings::system::SetAccountOnlineStorageSettings(nullptr, 0);

    EXPECT_EQ(
        0,
        ::nn::settings::system::GetAccountOnlineStorageSettings(
            settings, countMax));
}

namespace {

void ExpectEqualAccountOnlineStorageSettings(
    const ::nn::settings::system::AccountOnlineStorageSettings& lhs,
    const ::nn::settings::system::AccountOnlineStorageSettings& rhs) NN_NOEXCEPT
{
    EXPECT_EQ(lhs.uid, rhs.uid);
    EXPECT_EQ(
        lhs.flags.Test<
            ::nn::settings::system::AccountOnlineStorageFlag::
                SaveDataCheckAtLaunch>(),
        rhs.flags.Test<
            ::nn::settings::system::AccountOnlineStorageFlag::
                SaveDataCheckAtLaunch>());
}

} // namespace
