﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/settings/system/settings_Nfc.h>
#include <nnt/nntest.h>

//!< NFC が有効か否かを表す値の設定を取得可能か
TEST(NfcSuite, NfcEnableFlagTest1)
{
    ::nn::settings::system::IsNfcEnabled();
}

//!< NFC が有効か否かを表す値の設定を変更可能か
TEST(NfcSuite, NfcEnableFlagTest2)
{
    ::nn::settings::system::SetNfcEnabled(false);

    EXPECT_FALSE(::nn::settings::system::IsNfcEnabled());

    ::nn::settings::system::SetNfcEnabled(true);

    EXPECT_TRUE(::nn::settings::system::IsNfcEnabled());

    ::nn::settings::system::SetNfcEnabled(false);

    EXPECT_FALSE(::nn::settings::system::IsNfcEnabled());
}
