﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/settings/settings_Keyboard.h>
#include <nn/settings/system/settings_Keyboard.h>
#include <nnt/nntest.h>

//!< キーボード配列の種類を変更可能か
TEST(KeyboardSuite, KeyboardLayoutTest1)
{
    const auto layout = ::nn::settings::system::GetKeyboardLayout();

    ::nn::settings::system::SetKeyboardLayout(
        ::nn::settings::KeyboardLayout_Spanish);

    EXPECT_EQ(
        ::nn::settings::KeyboardLayout_Spanish,
        ::nn::settings::system::GetKeyboardLayout());

    ::nn::settings::system::SetKeyboardLayout(
        ::nn::settings::KeyboardLayout_Japanese);

    EXPECT_EQ(
        ::nn::settings::KeyboardLayout_Japanese,
        ::nn::settings::system::GetKeyboardLayout());

    ::nn::settings::system::SetKeyboardLayout(
        ::nn::settings::KeyboardLayout_Russian);

    EXPECT_EQ(
        ::nn::settings::KeyboardLayout_Russian,
        ::nn::settings::system::GetKeyboardLayout());

    ::nn::settings::system::SetKeyboardLayout(layout);
}
