﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/settings/system/settings_Capture.h>
#include <nnt/nntest.h>

//!< 撮影した画面写真を保存するストレージを表す値の設定を取得可能か
TEST(CaptureSuite, PrimaryAlbumStorageTest1)
{
    ::nn::settings::system::GetPrimaryAlbumStorage();
}

//!< 撮影した画面写真を保存するストレージを表す値の設定を変更可能か
TEST(CaptureSuite, PrimaryAlbumStorageTest2)
{
    ::nn::settings::system::SetPrimaryAlbumStorage(
        ::nn::settings::system::PrimaryAlbumStorage_SdCard);

    EXPECT_EQ(
        ::nn::settings::system::PrimaryAlbumStorage_SdCard,
        ::nn::settings::system::GetPrimaryAlbumStorage());

    ::nn::settings::system::SetPrimaryAlbumStorage(
        ::nn::settings::system::PrimaryAlbumStorage_Nand);

    EXPECT_EQ(
        ::nn::settings::system::PrimaryAlbumStorage_Nand,
        ::nn::settings::system::GetPrimaryAlbumStorage());

    ::nn::settings::system::SetPrimaryAlbumStorage(
        ::nn::settings::system::PrimaryAlbumStorage_SdCard);

    EXPECT_EQ(
        ::nn::settings::system::PrimaryAlbumStorage_SdCard,
        ::nn::settings::system::GetPrimaryAlbumStorage());
}
