﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   lsm6ds3 のドライバで使用するデバッグ用関数です
 */

#pragma once

#include <nn/nn_SdkLog.h>

#include "lsm6ds3_Types.h"

// #define NNT_SASBUS_LSM6DS3_DEBUG

#ifdef NNT_SASBUS_LSM6DS3_DEBUG
#define NNT_SASBUS_LSM6DS3_DETAIL_LOG(...) NN_SDK_LOG("nnt::sasbus::lsm6ds3::detail > " __VA_ARGS__);
#else
#define NNT_SASBUS_LSM6DS3_DETAIL_LOG(...)
#endif

namespace nnt {
namespace sasbus {
namespace lsm6ds3 {
namespace detail {

// SensorCountState をダンプします
void DebugDumpSensorCountState(const nnt::sasbus::lsm6ds3::SixAxisSensorCountState* pState);

} // detail
} // lsm6ds3
} // sasbus
} // nnt
