﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "textutils.h"

namespace helperutils
{

int ExtractFields(char *line, int numArgs, char *args[], const char *delim)
{
    int                         ret = -1;
    int                         count;

    args[0] = strtok(line, delim);
    if (args[0] == NULL)
    {
        //  Malformed, skip it.
        goto _errExit;
    }

    if (*args[0] == '#')
    {
        //  Comment, skip it
        goto _errExit;
    }

    for (count = 1; count < numArgs; count++)
    {
        args[count] = strtok(NULL, delim);
        if (args[count] == NULL)
        {
            //  Malformed line, bail out
            break;
        }
    }

    if (count == numArgs)
    {
        ret = 0;
    }

_errExit:
    return ret;
}

}
