﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#ifndef _EXECUTILS_H_
#define _EXECUTILS_H_

#pragma once

extern "C"
{

#define ENABLE_DUMP_ON_EXEC

typedef enum {
    MAX_ARGS  = 128,
} ExecConstants;


#define DECLARE_TEST_ARGS()          \
    int         testArgc;            \
    const char  *testArgv[MAX_ARGS];

#define TEST_ARGS_INIT()                       \
    do {                                       \
        testArgc = 0;                          \
        memset(testArgv, 0, sizeof(testArgv)); \
    } while(0)

#define ADD_TEST_ARG(arg)                      (testArgv[testArgc++] = arg)

#ifdef ENABLE_DUMP_ON_EXEC
#define CALL_TEST_MAIN(mainFunc)               doDumpAndCall(#mainFunc, (mainEntry)mainFunc, testArgc, (char **)testArgv)
#else
#define CALL_TEST_MAIN(mainFunc)               mainFunc(testArgc, (char **)testArgv)
#endif

#ifdef ENABLE_DEBUG_WAIT
#define EXEC_DEBUG_WAIT()  \
{                          \
    volatile int i = 1;    \
    while (i != 0);        \
}
#else
#define EXEC_DEBUG_WAIT()
#endif

typedef int (*mainEntry)(int, char **);
int doDumpAndCall(const char *name, mainEntry, int argc, char **argv);

}

namespace helperutils
{

typedef struct CmdArgsInfo
{
    char                        *execName;
    char                        *args[MAX_ARGS];
} CmdArgsInfoType;

void dumpCallInfo(const char *name, int argc, char **argv);

void PrepareCmdArgs(CmdArgsInfo *cmdArgInfo, int *argc, char **argv, int maxArgv);

}

#endif    //  _EXECUTILS_H_
