﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/os.h>
#include <nn/init.h>

#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Result.h>
#include <nn/socket/socket_Api.h>
#include <nn/socket/socket_SystemConfig.h>
#include <nn/fs/fs_SaveDataForDebug.h>
#include <nn/fs/fs_Mount.h>
#include <nnt.h>

#ifdef NNSDK_ENABLE_MTRACK
extern "C" {
#include "../src/md/nnsdk/mtrack.h"    //  NN SDK privat header, not in the path
}
#endif

extern "C" int testMain(int argc, char **argv);
static int   argc;
static char  **argv;

namespace
{

    const int TcpSocketLimit    = 16;
    const int UdpSocketLimit    = 0;
    const int ConcurrencyLimit  = 11;

    nn::socket::SystemConfigDefaultWithMemory
        <
        TcpSocketLimit, // Tcp Sockets
        UdpSocketLimit   // UDP Sockets
        > g_SocketConfigWithMemory(ConcurrencyLimit);


    static const char *g_DefaultSslMountPoint = "SslSave";
}

namespace nnt
{
namespace nspr
{

TEST(nspr, nspr_test)
{
    int ret;

    ret = testMain(argc, argv);

#ifdef NNSDK_ENABLE_MTRACK
    mtrackDumpLog();
#endif

    EXPECT_EQ(0, ret);
}

}    //  nspr
}    //  nnt


extern "C" void nnMain()
{
    argc = nnt::GetHostArgc();
    argv = nnt::GetHostArgv();

    // GoogleTest おまじない
    ::testing::InitGoogleTest(&argc, argv);

    //  Init socket library

    nn::Result status = nn::socket::Initialize(g_SocketConfigWithMemory);
    ASSERT_EQ(true, status.IsSuccess());

    //  Mount save space used for filesystem access on platform and Win.  Use the
    //  default mount point that SSL uses since NSPR assumes this.
    status = nn::fs::MountSaveDataForDebug(g_DefaultSslMountPoint);
    ASSERT_EQ(true, status.IsSuccess());

    int result = RUN_ALL_TESTS();

    // テスト終了
    NN_LOG("\n=== End Test of test (%s)\n",
           (result == 0) ? "PASSED" : "FAILED");

    //  Finish the socket lib
    nn::socket::Finalize();

    nn::fs::Unmount(g_DefaultSslMountPoint);

    nnt::Exit(result);
}
