﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/mem/mem_StandardAllocator.h>

class TestAllocator
{
public:
    static TestAllocator& GetInstance() NN_NOEXCEPT
    {
        static TestAllocator allocator;
        return allocator;
    }

    nn::mem::StandardAllocator* GetAllocator() NN_NOEXCEPT { return &m_Allocator; }

private:
    TestAllocator() NN_NOEXCEPT;
    ~TestAllocator() NN_NOEXCEPT;

    nn::mem::StandardAllocator m_Allocator;
    uintptr_t m_HeapAddress;
};

