﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/gtest/gtest.h>
#include <nn/ro.h>

#include "util_Common.h"
#include "test_StaticObject.h"

namespace {
    const char* BinStatic1Name = "nro/BinStatic1.nro";
    const char* BinStatic2Name = "nro/BinStatic2.nro";

    int g_IdArray[5];
    int g_IdIndex;

    class StaticObjectTest : public ::testing::TestWithParam<nn::ro::BindFlag>
    {
    protected:

        virtual void SetUp()
        {
            TestAllocator& mgr = TestAllocator::GetInstance();
            m_Nro1.SetUp(BinStatic1Name, mgr.GetAllocator());
            m_Nro2.SetUp(BinStatic2Name, mgr.GetAllocator());
            nn::ro::Initialize();
        }

        virtual void TearDown()
        {
            nn::ro::Finalize();
        }

        TestNro m_Nro1;
        TestNro m_Nro2;
    };
} // namespace

void SetClassId(int id)
{
    g_IdArray[g_IdIndex++] = id;
}

INSTANTIATE_TEST_CASE_P(ManualDll, StaticObjectTest, ::testing::Values(nn::ro::BindFlag_Lazy, nn::ro::BindFlag_Now));

TEST_P(StaticObjectTest, Bind)
{
    g_IdIndex = 0;

    auto result = m_Nro1.Load(GetParam());
    NN_ASSERT_RESULT_SUCCESS(result);

    // コンストラクタの順番のテスト
    for (int i = 0; i < g_IdIndex - 1; i++)
    {
        ASSERT_EQ(i, g_IdArray[i]);
        if (i == g_IdIndex - 2)
        {
            ASSERT_EQ(i + TestClass2::IdOffset, g_IdArray[i + 1]);
        }
    }

    g_IdIndex = 0;

    m_Nro1.Unload();

    // デストラクタの順番のテスト
    for (int i = 0; i < g_IdIndex; i++)
    {
        if (i == 0)
        {
            ASSERT_EQ((g_IdIndex - 2) + TestClass2::IdOffset, g_IdArray[i]);
        }
        else
        {
            ASSERT_EQ((g_IdIndex - 1 - i), g_IdArray[i]);
        }
    }
}

// BSS セクションを DATA セクションの残りではなく、単独でバッファを確保して使用する NRO のテスト
TEST_P(StaticObjectTest, BindSoloBss)
{
    g_IdIndex = 0;

    auto result = m_Nro2.Load(GetParam());
    NN_ASSERT_RESULT_SUCCESS(result);

    // コンストラクタの順番のテスト
    for (int i = 0; i < g_IdIndex - 1; i++)
    {
        ASSERT_EQ(i, g_IdArray[i]);
        if (i == g_IdIndex - 2)
        {
            ASSERT_EQ(i + TestClass2::IdOffset, g_IdArray[i + 1]);
        }
    }

    g_IdIndex = 0;

    m_Nro2.Unload();

    // デストラクタの順番のテスト
    for (int i = 0; i < g_IdIndex; i++)
    {
        if (i == 0)
        {
            ASSERT_EQ((g_IdIndex - 2) + TestClass2::IdOffset, g_IdArray[i]);
        }
        else
        {
            ASSERT_EQ((g_IdIndex - 1 - i), g_IdArray[i]);
        }
    }
}

