﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

template <typename T>
class TestClassBase
{
public:
    explicit TestClassBase(T n)
        : m_T(n)
    {
    }

    ~TestClassBase()
    {
    }

    T Get() const { return m_T; }
    virtual T Calc() const { return m_T; }

protected:
    T m_T;
};

class TestClassInt : public TestClassBase<int>
{
public:
    explicit TestClassInt(int n)
        : TestClassBase(n)
    {
    }

    virtual int Calc() const { return m_T + 1; }
};

