﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

#include <nn/rid/rid_MenuUpdateApi.h>

class RidTestMenuUpdater
{
public:
    RidTestMenuUpdater() NN_NOEXCEPT;
    ~RidTestMenuUpdater() NN_NOEXCEPT;

    void Start() NN_NOEXCEPT;
    nn::Result GetLastResult() NN_NOEXCEPT
    {
        return m_MenuUpdateResult;
    }

    bool IsUpdateProcessDone() NN_NOEXCEPT
    {
        return m_IsMenuUpdateDone;
    }

    std::string GetState() NN_NOEXCEPT;

private:
    bool m_IsStartUpdate;
    nn::Result m_MenuUpdateResult;
    bool m_IsMenuUpdateDone;

    nn::rid::MenuUpdater m_MenuUpdater;
    nn::os::ThreadType m_UpdateExecutionThread;
};
