﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/usb/usb_PmTypes.h>

namespace nn { namespace usb {

class PmClient
{
public:
    Result Initialize() NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;

    nn::os::SystemEventType* GetPowerEvent() NN_NOEXCEPT;
    Result GetPowerState(UsbPowerState *pOutState) NN_NOEXCEPT;

    // PSM は Data Role を使っていない
    // nn::os::SystemEventType* GetDataEvent() NN_NOEXCEPT;
    // Result GetDataRole(UsbDataRole *pOutRole) NN_NOEXCEPT;
};

}} // namespace nn::usb

namespace nnt { namespace usb {

void SetPmPowerState(const nn::usb::UsbPowerState& state) NN_NOEXCEPT;
void SignalPmPowerEvent() NN_NOEXCEPT;

}} // namespace nnt::usb
