﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/spl/spl_Api.h>

#include "testPsm_SplStub.h"

namespace {

::nn::spl::HardwareType g_HardwareType = ::nn::spl::HardwareType_Icosa;

::nn::Bit64 g_IsChargerHiZModeEnabled = 0;

} // namespace

namespace nn { namespace spl {

void Initialize() NN_NOEXCEPT
{
}

void Finalize() NN_NOEXCEPT
{
}

Result GetConfig(Bit64* pOut, ConfigItem key) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL(pOut);
    NN_ASSERT(key == ConfigItem_HardwareType);

    *pOut = static_cast<Bit64>(g_HardwareType);

    NN_RESULT_SUCCESS;
}

Result SetConfig(ConfigItem  key, Bit64 value) NN_NOEXCEPT
{
    if ( key == ::nn::spl::ConfigItem_IsChargerHiZModeEnabled )
    {
        g_IsChargerHiZModeEnabled = value;
    }

    NN_RESULT_SUCCESS;
}

}} // namespace ::nn::spl

namespace nnt { namespace spl {

void SetHardwareType(::nn::spl::HardwareType hardwareType) NN_NOEXCEPT
{
    g_HardwareType = hardwareType;
}

::nn::Bit64 GetIsChargerHiZModeEnabled() NN_NOEXCEPT
{
    return g_IsChargerHiZModeEnabled;
}

}} // namespace nnt::spl
