﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "psm_ChargerDriver.h"

namespace nnt { namespace psm { namespace driver { namespace detail {

enum ChargeConfiguration
{
    ChargeConfiguration_ChargeBattery,
    ChargeConfiguration_ChargeOTG,
    ChargeConfiguration_Disable,
};

int GetChargeCurrentLimitMilliAmpere() NN_NOEXCEPT;

int GetInputCurrentLimitMilliAmpere() NN_NOEXCEPT;

int GetInputVoltageLimitMilliVolt() NN_NOEXCEPT;

int GetOutputCurrentLimitMilliAmpere() NN_NOEXCEPT;

int GetChargeVoltageLimitMilliVolt() NN_NOEXCEPT;

bool IsWatchdogTimerEnabled() NN_NOEXCEPT;

ChargeConfiguration GetChargeConfiguration() NN_NOEXCEPT;

::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption GetChargeCurrentLimitOption() NN_NOEXCEPT;

void SetHiZCondition(bool hiZCondition) NN_NOEXCEPT;

bool GetHiZCondition() NN_NOEXCEPT;

void SetStatus(::nn::psm::driver::detail::ChargerDriver::Status status) NN_NOEXCEPT;

}}}} // namespace nnt::psm::driver::detail
