﻿[int]$testProfiler_Common_testCount = 0
[int]$testProfiler_Common_failCount = 0

function WriteTestName($testName)
{
    write-output "[----------] $testName"
}

function WriteOutputRun()
{
    write-output "[ RUN      ]"
}

function WriteOutputResult($succeeded)
{
    if ($succeeded -eq $true)
    {
        write-output "[       OK ]"
    }
    else
    {
        write-output "[     FAIL ]"
    }
}

function WriteError($message)
{
    write-output $message
    write-error $message
}

function WaitForCheckersToFinish()
{
    [Nintendo.CPU.Profiler.ModelData]::Get().CheckersFinished.WaitOne()
}

function RunTest($testName)
{
    ++$global:testProfiler_Common_testCount
    WriteTestName($testName)
    WriteOutputRun

    [Boolean]$failed = $true;
    $returnValue = & $testName
    if ($returnValue -is [System.Array])
    {
        $count = $returnValue.Length
        [Boolean]$failed = $returnValue[$count - 1]
        for ($i = 0; $i -lt ($count - 1); ++$i)
        {
            write-output $returnValue[$i]
        }
    }
    elseif ($returnValue -is [Boolean])
    {
        $failed = $returnValue;
    }
    else
    {
        $retvalType = $returnValue.GetType()
        write-error "Received a bad type for return value: $retvalType -> $returnValue"
        $failed = $true
    }

    if ($failed)
    {
        ++$global:testProfiler_Common_failCount
    }
    $succeeded = !$failed
    WriteOutputResult($succeeded)
}

function TestsFinished()
{
    [int]$exitCode = 0
    if ($global:testProfiler_Common_failCount)
    {
        write-output "[  FAILED  ] $global:testProfiler_Common_failCount of $global:testProfiler_Common_testCount tests"
        $exitCode = $global:testProfiler_Common_failCount
    }
    else
    {
        write-output "[  PASSED  ] $global:testProfiler_Common_testCount tests"
    }

    [Environment]::Exit($exitCode)
    #profiler-exit $testProfiler_Common_failCount -WarningsAsErrors
}

function SyncWhenAvailable()
{
    profiler-exit 0 -WarningsAsErrors
    
    $synced = $false
    for ($loop = 0; ($loop -lt 2) -and ($synced -eq $false); ++$loop)
    {
        write-output "Waiting for devkit..."
        profiler-waitfor CanSync
        write-output "Connecting to devkit..."
        $connected = profiler-connect
        if ($connected -eq $false)
        {
            write-error "Could not Connect"
            exit
        }
        
        write-output "Waiting for RunTime..."
        profiler-nx-waitfor InProcessAvailable
        
        $nssFile = [string]::Empty
        
        write-output "Setting scenario"
        profiler-nx-scenario AttachToInProcess -NssFile $nssFile -Autofill
        write-output "Attempting to Sync..."
        $synced = profiler-sync
    } 
    if ($synced -eq $false)
    {
        write-error "Could not Sync"
        exit
    }
    write-output "Synced!"
    sleep 1
    
    if ($SampleMode -eq [Nintendo.CPU.Profiler.Scripting.NX.ScriptingSampleMode]::OutOfProcess)
    {
        write-output "Using Out-of-Process profiling"
        profiler-nx-waitfor OutOfProcessAvailable
        profiler-nx-samplemode OutOfProcess
    }
    else
    {
        write-output "Using In-Process profiling"
        profiler-nx-samplemode InProcess
    }
}
