﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nn_Log.h>
#include <nn/account.h>
#include <nn/prepo.h>

#include <nn/util/util_StringUtil.h>
#include <nn/util/util_Uuid.h>

TEST(SaveReport, Main)
{
    int argc = nnt::GetHostArgc();
    char** argv = nnt::GetHostArgv();

    ASSERT_EQ(3, argc);

    const int userIndex = std::atoi(argv[1]);
    ASSERT_GE(userIndex, -1);
    ASSERT_LT(userIndex, nn::account::UserCountMax);

    const char* uuid = argv[2];
    ASSERT_EQ(nn::util::Uuid::StringSize - 1, nn::util::Strnlen(uuid, nn::util::Uuid::StringSize));

    nn::prepo::PlayReport report("test_user_agreement_check");

    static nn::Bit8 buffer[nn::prepo::PlayReport::BufferSizeMin + nn::prepo::KeyValueSizeMax];
    report.SetBuffer(buffer, sizeof (buffer));

    NNT_ASSERT_RESULT_SUCCESS(report.Add("uuid", uuid));

    if (userIndex == -1)
    {
        NN_LOG("Save the report (uid=nil, data=uuid:%s)\n", uuid);
        NNT_ASSERT_RESULT_SUCCESS(report.Save());
    }
    else
    {
        nn::account::Initialize();

        nn::account::Uid users[nn::account::UserCountMax];
        int userCount;
        NNT_ASSERT_RESULT_SUCCESS(nn::account::ListAllUsers(&userCount, users, nn::account::UserCountMax));
        ASSERT_LT(userIndex, userCount);

        NN_LOG("Save the report (uid=%016llx_%016llx, data=uuid:%s)\n", users[userIndex]._data[0], users[userIndex]._data[1], uuid);
        NNT_ASSERT_RESULT_SUCCESS(report.Save(users[userIndex]));
    }
}
