﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nn_Common.h>
#include <nn/nifm.h>
#include <nn/nifm/nifm_ApiForMenu.h>
#include <nn/nifm/nifm_ApiForSystem.h>
#include <nn/nifm/nifm_NetworkConnection.h>

#include <nn/prepo/detail/service/core/prepo_DeviceAuthenticationToken.h>

TEST(Get, Basic)
{
    NNT_ASSERT_RESULT_SUCCESS(nn::nifm::InitializeSystem());

    nn::nifm::NetworkConnection nc;

    NNT_ASSERT_RESULT_SUCCESS(nn::nifm::SetRequestRequirementPreset(nc.GetRequestHandle(),
        nn::nifm::RequirementPreset_InternetForSystemProcessSharable));

    nc.SubmitRequestAndWait();

    ASSERT_TRUE(nc.IsAvailable());

    const char* authToken = nullptr;

    NNT_ASSERT_RESULT_SUCCESS(nn::prepo::detail::service::core::DeviceAuthenticationToken::GetInstance().Get(&authToken, false));

    char firstToken[nn::dauth::RequiredBufferSizeForDeviceAuthenticationToken] = {};
    std::memcmp(firstToken, authToken, sizeof (firstToken));

    NNT_ASSERT_RESULT_SUCCESS(nn::prepo::detail::service::core::DeviceAuthenticationToken::GetInstance().Get(&authToken, false));

    char secondToken[nn::dauth::RequiredBufferSizeForDeviceAuthenticationToken] = {};
    std::memcmp(secondToken, authToken, sizeof (secondToken));

    EXPECT_STREQ(firstToken, secondToken); // キャッシュされているから、同じトークンが取れる。

    NNT_ASSERT_RESULT_SUCCESS(nn::prepo::detail::service::core::DeviceAuthenticationToken::GetInstance().Get(&authToken, true));

    char thirdToken[nn::dauth::RequiredBufferSizeForDeviceAuthenticationToken] = {};
    std::memcmp(thirdToken, authToken, sizeof (thirdToken));

    EXPECT_STREQ(firstToken, thirdToken); // forceUpdate フラグを true にしているから、新しいトークンが取れる。
}
