﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>

#include <nn/apm/apm_System.h>

namespace nn { namespace apm {

nn::os::SystemEventType g_SleepRequiredByLowVoltageEvent;

void InitializeForSystem() NN_NOEXCEPT
{
    nn::os::CreateSystemEvent(&g_SleepRequiredByLowVoltageEvent, nn::os::EventClearMode_ManualClear, true);
}

void FinalizeForSystem() NN_NOEXCEPT
{
    nn::os::DestroySystemEvent(&g_SleepRequiredByLowVoltageEvent);
}

void GetPerformanceEvent(nn::os::SystemEventType* pOutSystemEvent, EventTarget eventTarget, nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    switch ( eventTarget )
    {
    case EventTarget_SleepRequiredByLowVoltage:
        nn::os::AttachReadableHandleToSystemEvent(pOutSystemEvent,
            nn::os::GetReadableHandleOfSystemEvent(&g_SleepRequiredByLowVoltageEvent), false, clearMode);
        break;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

void SignalPerformanceEvent(EventTarget eventTarget) NN_NOEXCEPT
{
    switch ( eventTarget )
    {
    case EventTarget_SleepRequiredByLowVoltage:
        nn::os::SignalSystemEvent(&g_SleepRequiredByLowVoltageEvent);
        break;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

}} // namespace nn::apm
