﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/psc/server/psc_Server.h>
#include <nn/init.h>
#include <nnt/gtest/gtest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/base/testBase_Exit.h>

// アロケータ用のバッファ
NN_ALIGNAS(4096) uint8_t  g_MallocBuffer[1 * 1024 * 1024];
extern "C" void nninitStartup()
{
    nn::init::InitializeAllocator(g_MallocBuffer, sizeof(g_MallocBuffer));
}

namespace {
    const size_t StackSize = (16 * 1024);
    uint8_t g_Stack[StackSize] NN_ALIGNAS(4096);

    const size_t PscMemoryPoolSize = (128 * 1024);
    uint8_t g_PscMemory[PscMemoryPoolSize] NN_ALIGNAS(4096);

    void ThreadPscServer(void*)
    {
        nn::Result result = nn::psc::server::Initialize(g_PscMemory, sizeof(g_PscMemory));
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);

        nn::psc::server::Wait();
    }
}

extern "C" void nnMain()
{
    // Start psc server
    nn::os::ThreadType thread;
    nn::os::CreateThread(&thread, ThreadPscServer, nullptr, g_Stack, sizeof(g_Stack), nn::os::DefaultThreadPriority);
    nn::os::StartThread(&thread);

    // Start gtest
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    int result = RUN_ALL_TESTS();
    ::nnt::Exit(result);
}
