﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nnt/nntest.h>

#include "testOe_Init.h"
#include "testOe_PrivilegedPerformanceConfigurationTest.h"

namespace nnt { namespace oe {

namespace {

INSTANTIATE_TEST_CASE_P(ConfigInfos, PrivilegedPerformanceConfigurationTest, ::testing::ValuesIn(PrivilegedConfigInfoList));

} // namespace

TEST_P(PrivilegedPerformanceConfigurationTest, SetConfigAndCheckFrequenciesPrivilegedWithCpuOverclock)
{
    ConfigInfo configInfo = GetParam();
    configInfo.cpuSetting = CpuOverclockSetting;
    SetConfigAndCheckFrequencies(configInfo);
}

TEST_P(PrivilegedPerformanceConfigurationTest, SetConfigAndCheckFrequenciesOnNormalPrivilegedWithCpuOverclock)
{
    ConfigInfo configInfo = GetParam();
    configInfo.cpuSetting = CpuOverclockSetting;
    SetConfigAndCheckFrequenciesOnNormal(configInfo);
}

TEST_P(PrivilegedPerformanceConfigurationTest, SetConfigAndCheckFrequenciesOnBoostPlivilegedWithCpuOverclock)
{
    ConfigInfo configInfo = GetParam();
    configInfo.cpuSetting = CpuOverclockSetting;
    SetConfigAndCheckFrequenciesOnBoost(configInfo);
}

}} // namespace nnt::oe
