﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/oe.h>

#include <nnt/nntest.h>

#include "testOe_Init.h"
#include "testOe_PrivilegedPerformanceConfigurationTest.h"

namespace nnt { namespace oe {

namespace {

INSTANTIATE_TEST_CASE_P(ConfigInfos, PrivilegedPerformanceConfigurationTest, ::testing::ValuesIn(PrivilegedConfigInfoList));

} // namespace

TEST_P(PrivilegedPerformanceConfigurationTest, SetConfigAndCheckFrequenciesPrivileged)
{
    SetConfigAndCheckFrequencies(GetParam());
}

TEST_P(PrivilegedPerformanceConfigurationTest, SetConfigAndCheckFrequenciesOnNormalPrivileged)
{
    SetConfigAndCheckFrequenciesOnNormal(GetParam());
}

TEST_P(PrivilegedPerformanceConfigurationTest, SetConfigAndCheckFrequenciesOnBoostPlivileged)
{
    SetConfigAndCheckFrequenciesOnBoost(GetParam());
}

TEST_P(PrivilegedPerformanceConfigurationTest, SetDeathConfigAndCheckFrequenciesPrivileged)
{
    SetDeathConfigAndCheckFrequencies(GetParam());
}

TEST_P(PrivilegedPerformanceConfigurationTest, SetDeathConfigAndCheckFrequenciesOnNormalPrivileged)
{
    SetDeathConfigAndCheckFrequenciesOnNormal(GetParam());
}

TEST_P(PrivilegedPerformanceConfigurationTest, SetDeathConfigAndCheckFrequenciesOnBoostPlivileged)
{
    SetDeathConfigAndCheckFrequenciesOnBoost(GetParam());
}

TEST_P(PrivilegedPerformanceConfigurationTest, SetConfigAndCheckFrequenciesOnNormalPrivilegedAndBoostPublic)
{
    const nn::oe::PerformanceConfiguration toBeKeptConfiguration = nn::oe::PerformanceConfiguration_Cpu1020MhzGpu768MhzEmc1600Mhz;

    // ノーマルモード側に特権開発者が使える性能を設定する。PerformanceMode_Normal の性能しか入れられない。
    if ( IsSettableToPerformanceModeNormal(GetParam()) )
    {
        // 特権開発者でなくても使える性能をブーストモード側に設定する。
        nn::oe::SetPerformanceConfiguration(nn::oe::PerformanceMode_Boost, toBeKeptConfiguration);

        // 特権開発者が使える性能をノーマルモード側に設定する。
        nn::oe::SetPerformanceConfiguration(nn::oe::PerformanceMode_Normal, GetParam().config);

        // 性能設定が揮発していないことを確認する。
        EXPECT_EQ(nn::oe::GetPerformanceConfiguration(nn::oe::PerformanceMode_Boost), toBeKeptConfiguration);
        EXPECT_EQ(nn::oe::GetPerformanceConfiguration(nn::oe::PerformanceMode_Normal), GetParam().config);

        // 現在の性能モードがノーマルモードならばそのままチェックする。
        if ( nn::oe::GetPerformanceMode() == nn::oe::PerformanceMode_Normal )
        {
            CheckFrequencies(GetParam());
        }
        else
        {
            CheckFrequencies(1020000000, 768000000, 1600000000);
        }
    }
}

TEST_P(PrivilegedPerformanceConfigurationTest, SetConfigAndCheckFrequenciesOnBoostPlivilegedAndNormalPublic)
{
    const nn::oe::PerformanceConfiguration toBeKeptConfiguration = nn::oe::PerformanceConfiguration_Cpu1020MhzGpu384MhzEmc1331Mhz;

    if ( IsSettableToPerformanceModeBoost(GetParam()) )
    {
        // 特権開発者でなくても使える性能をノーマルモード側に設定する。
        nn::oe::SetPerformanceConfiguration(nn::oe::PerformanceMode_Normal, toBeKeptConfiguration);

        // 特権開発者が使える性能をブーストモード側に設定する。
        nn::oe::SetPerformanceConfiguration(nn::oe::PerformanceMode_Boost, GetParam().config);

        // 性能設定が揮発していないことを確認する。
        EXPECT_EQ(nn::oe::GetPerformanceConfiguration(nn::oe::PerformanceMode_Normal), toBeKeptConfiguration);
        EXPECT_EQ(nn::oe::GetPerformanceConfiguration(nn::oe::PerformanceMode_Boost), GetParam().config);

        // 現在の性能モードがブーストモードならばそのままチェックする。
        if ( nn::oe::GetPerformanceMode() == nn::oe::PerformanceMode_Boost )
        {
            CheckFrequencies(GetParam());
        }
        else
        {
            CheckFrequencies(1020000000, 384000000, 1331200000);
        }
    }
}

}} // namespace nnt::oe
