﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fgm/fgm.h>
#include <nn/oe.h>

namespace nnt { namespace oe {

const nn::fgm::Setting CpuOverclockSetting = 1785000000;

struct ConfigInfo
{
    // TODO: mode が PerformanceMode_Boost の場合 PerformanceMode_Boost と PerformanceMode_Normal の両方で使用可能を含意している
    // NX では PerformanceMode_Normal で使用可能な性能はすべて PerformanceMode_Boost で使用可能なので問題にならない
    // 理想的には対応する PerformanceMode を列挙する形にするべき
    nn::oe::PerformanceMode mode;
    nn::oe::PerformanceConfiguration config;
    nn::fgm::Setting cpuSetting;
    nn::fgm::Setting gpuSetting;
    nn::fgm::Setting emcSetting;
};

void CheckFrequencies(nn::fgm::Setting cpuSetting, nn::fgm::Setting gpuSetting, nn::fgm::Setting emcSetting) NN_NOEXCEPT;
void CheckFrequencies(const nnt::oe::ConfigInfo& param) NN_NOEXCEPT;
void PreInitializeTestEnvironment() NN_NOEXCEPT;
void InitializeTestEnvironment() NN_NOEXCEPT;

bool IsSettableToAllPerformanceMode(const ConfigInfo& configInfo) NN_NOEXCEPT;
bool IsSettableToPerformanceModeNormal(const ConfigInfo& configInfo) NN_NOEXCEPT;
bool IsSettableToPerformanceModeBoost(const ConfigInfo& configInfo) NN_NOEXCEPT;

void SetConfigAndCheckFrequencies(const ConfigInfo& configInfo) NN_NOEXCEPT;
void SetConfigAndCheckFrequenciesOnNormal(const ConfigInfo& configInfo) NN_NOEXCEPT;
void SetConfigAndCheckFrequenciesOnBoost(const ConfigInfo& configInfo) NN_NOEXCEPT;

void SetDeathConfigAndCheckFrequencies(const ConfigInfo& configInfo) NN_NOEXCEPT;
void SetDeathConfigAndCheckFrequenciesOnNormal(const ConfigInfo& configInfo) NN_NOEXCEPT;
void SetDeathConfigAndCheckFrequenciesOnBoost(const ConfigInfo& configInfo) NN_NOEXCEPT;

}} // namespace nnt::oe
