﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/pcm/pcm.h>
#include <nn/pcv/pcv.h>
#include <nn/result/result_HandlingUtility.h>

#include <nnt/nntest.h>

#include "../Common/ExpectedDefaultStates.h"
#include "../Common/ModuleNames.h"

namespace nnt { namespace pcv {

namespace {

// チェック対象となるモジュールを列挙する。
// 既に使用されているモジュールはチェックしない。
const nn::pcv::Module GatingModules[] =
{
    nn::pcv::Module_I2s1,
    nn::pcv::Module_I2s3,
    nn::pcv::Module_I2c1,
    nn::pcv::Module_I2c4,
    nn::pcv::Module_I2c5,
    nn::pcv::Module_I2c6,
    nn::pcv::Module_Spi1,
    nn::pcv::Module_Spi2,
    nn::pcv::Module_Spi3,
    nn::pcv::Module_Spi4,
    nn::pcv::Module_Disp1,
    nn::pcv::Module_Disp2,
    nn::pcv::Module_Sdmmc3,
    nn::pcv::Module_Csite,
    nn::pcv::Module_Tsec,
    nn::pcv::Module_Mselect,
    nn::pcv::Module_Hda2codec2x,
    // nn::pcv::Module_Sor1, // SIGLO-48880 Copper 起動時に使用している為コメントアウト
    nn::pcv::Module_Hda,
    nn::pcv::Module_XusbCoreHostSrc,
    nn::pcv::Module_XusbFalconSrc,
    nn::pcv::Module_XusbFsSrc,
    nn::pcv::Module_XusbCoreDevSrc,
    nn::pcv::Module_XusbSsSrc,
    nn::pcv::Module_UartA,
    nn::pcv::Module_Hostx,
    nn::pcv::Module_Ape,
    nn::pcv::Module_AudioDsp,
    nn::pcv::Module_Emc,
    nn::pcv::Module_Dsi,
    nn::pcv::Module_Maud,
    nn::pcv::Module_Dpaux1,
    nn::pcv::Module_MipiCal,
    nn::pcv::Module_Osc,
    nn::pcv::Module_SysBus,
    nn::pcv::Module_SorSafe,
    // nn::pcv::Module_XusbSs, // SIGLO-48880 Copper 起動時に使用している為コメントアウト
    // nn::pcv::Module_XusbHost, // SIGLO-48880 Copper 起動時に使用している為コメントアウト
    // nn::pcv::Module_XusbDevice, // SIGLO-50659
    nn::pcv::Module_Extperiph1,
    nn::pcv::Module_Ahub,
    nn::pcv::Module_Hda2hdmicodec,
    nn::pcv::Module_Gpuaux,
    // nn::pcv::Module_UsbD, // SIGLO-48880 Copper 起動時に使用している為コメントアウト
    nn::pcv::Module_Usb2,
    nn::pcv::Module_Usb2TrkClk,
};

class ClockGatingTest : public ::testing::TestWithParam<nn::pcv::Module>{};

INSTANTIATE_TEST_CASE_P(GatingModules, ClockGatingTest, ::testing::ValuesIn(GatingModules));

}

// ClockGating が想定通りであることの確認。
TEST_P(ClockGatingTest, CheckClockGatingDefault)
{
    nn::pcv::ModuleState state;
    NN_ABORT_UNLESS_RESULT_SUCCESS(GetState(&state, GetParam()));
    NN_LOG("%s clock enabled: %s.\n", nnt::pcv::GetModuleName(GetParam()), state.clockEnabled ? "true" : "false");
    EXPECT_EQ(GetClockEnabledDefault(GetParam()), state.clockEnabled);
}

}} // namespace nnt::pcv
