﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <vector>

#include <nn/nn_Common.h>

#include <nn/pcv/pcv.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

#include <nnt/nntest.h>

#include "IsValidPowerControlTarget.h"

namespace nnt { namespace pcv {

namespace {

const std::vector<nn::pcv::PowerControlTarget> ValidPowerControlTargetsForInvalidPlatform =
{
};

const std::vector<nn::pcv::PowerControlTarget> ValidPowerControlTargetsForIcosa =
{
    nn::pcv::PowerControlTarget_SdCard,
    nn::pcv::PowerControlTarget_Hdmi,
};

const std::vector<nn::pcv::PowerControlTarget> ValidPowerControlTargetsForHoag =
{
    nn::pcv::PowerControlTarget_SdCard,
    nn::pcv::PowerControlTarget_SioMcu,
    nn::pcv::PowerControlTarget_SioMcuA,
};

const std::vector<nn::pcv::PowerControlTarget>* GetValidPowerControlTargets() NN_NOEXCEPT
{
    const char* const name = "platformconfig";
    const char* const key = "platformtype";

    size_t size = ::nn::settings::fwdbg::GetSettingsItemValueSize(name, key);
    EXPECT_NE(0, size);

    char buffer[size];
    EXPECT_EQ(size, ::nn::settings::fwdbg::GetSettingsItemValue(buffer, size, name, key));

    if ( std::strcmp("Icosa", buffer) == 0 )
    {
        return &ValidPowerControlTargetsForIcosa;
    }
    else if ( std::strcmp("Copper", buffer) == 0 )
    {
        return &ValidPowerControlTargetsForIcosa;
    }
    else if ( std::strcmp("Hoag", buffer) == 0 )
    {
        return &ValidPowerControlTargetsForHoag;
    }
    else if ( std::strcmp("IcosaMariko", buffer) == 0 )
    {
        return &ValidPowerControlTargetsForIcosa;
    }

    NN_ABORT("Invalid platformtype.");

    return &ValidPowerControlTargetsForInvalidPlatform;
}

} // namespace

bool IsValidPowerControlTarget(nn::pcv::PowerControlTarget powerControlTarget) NN_NOEXCEPT
{
    const std::vector<nn::pcv::PowerControlTarget>* pValidPowerControlTargets = GetValidPowerControlTargets();
    auto pFound = std::find(pValidPowerControlTargets->cbegin(), pValidPowerControlTargets->cend(), powerControlTarget);
    return pFound != pValidPowerControlTargets->cend();
}

}} // namespace nnt::pcv
