﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/pcv/pcv.h>
#include <nn/nn_Common.h>
#include <nnt/nntest.h>


TEST(GetTemperatureThresholdsTest, CheckThresholds)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());
    nn::pcv::TemperatureThreshold thresholds[nn::pcv::MaxNumTemperatureThresholds];
    memset(thresholds, 0, sizeof(thresholds) / sizeof(thresholds[0]));

    int numThresholds = 0;

    nn::Result result;

    result = nn::pcv::GetTemperatureThresholds(
        thresholds,
        &numThresholds,
        nn::pcv::MaxNumTemperatureThresholds);

    ASSERT_TRUE(result.IsSuccess());

    for (int i=0; i < numThresholds; ++i)
    {
        EXPECT_GT(thresholds[i].maxMilliC, thresholds[i].minMilliC);
    }

}

TEST(GetTemperatureThresholdsTest, InvalidMaxCount)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());
    nn::pcv::TemperatureThreshold thresholds[nn::pcv::MaxNumTemperatureThresholds];
    memset(thresholds, 0, sizeof(thresholds) / sizeof(thresholds[0]));

    int numThresholds = 0;

    nn::Result result;
    result = nn::pcv::GetTemperatureThresholds(thresholds, &numThresholds, -1);
    EXPECT_FALSE(result.IsSuccess());
}
