﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt.h>

namespace nn
{
namespace pctl
{
namespace test
{

static const int PairingCodeLengthMax = 16;
static const int DeviceIdLengthMax = 32;
static const int AccessTokenLengthMax = 1024;
static const int NintendoAccountIdMax = 32;

/**
* @brief ペアリングのWebAPIに必要な情報を格納する為の構造体です
*
* - @ref GetPairingInfo()
*/
struct PairingInfo
{
    char pairingCode[PairingCodeLengthMax];
    char deviceId[DeviceIdLengthMax];
    char accessToken[AccessTokenLengthMax];
    char nintendoAccountId[NintendoAccountIdMax];
};

/**
* @brief ペアリングのWebAPIに必要な情報を含む構造体を取得します
*
* @param[out] pOutPairingInfo ペアリングのWebAPIに必要な情報を含む構造体
* @param[in] pEmail          みまもりを行うアカウントの e-mail アドレス
* @param[in] pPassword       みまもりを行うアカウントのパスワード
*
* @details
*  予めスマートデバイスアプリを用いて、指定のユーザーでログイン、初回連携を行っておく必要があります。
**/
nn::Result GetPairingInfo(PairingInfo* pOutPairingInfo, const char* pEmail, const char* pPassword) NN_NOEXCEPT;

/**
* @brief 本体の登録状態に関わらずペアリングを強制解除します
*
* @param[in] pairingInfo ペアリングのWebAPIに必要な情報を含む構造体
*
* @details
*  予めスマートデバイスアプリを用いて、指定のユーザーでログイン、初回連携を行っておく必要があります。
**/
nn::Result ForceUnlinkPairing(const PairingInfo* pairingInfo) NN_NOEXCEPT;

}
}
}
