﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdlib>
#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nnt.h>

#include <nn/pcie/pcie.h>

TEST( PcieServer_UnregisteredQuery, Initialize)
{
    NNT_EXPECT_RESULT_SUCCESS(nn::pcie::Initialize());
}

TEST( PcieServer_UnregisteredQuery, QueryFunctions)
{
    nn::pcie::FunctionState functionStates[nn::pcie::MaxEnumeratedDeviceFunctions];
    int32_t functionCount = 0;
    NNT_EXPECT_RESULT_SUCCESS(nn::pcie::QueryFunctions(functionStates, &functionCount, sizeof(functionStates)));
    if(functionCount <= 0)
    {
        NN_LOG("QueryFunctions() did not provide anything.\n");
        ADD_FAILURE();
    }
    for(int32_t i = 0; i < functionCount; i++)
    {
        nn::pcie::FunctionState *pF = functionStates + i;
        NN_LOG("Query out %d\n",i);
        NN_LOG("  functionHandle = 0x%llx\n", static_cast<uint64_t>(pF->functionHandle));
        NN_LOG("  vendorId       = 0x%x\n", pF->vendorId);
        NN_LOG("  deviceId       = 0x%x\n", pF->deviceId);
        NN_LOG("  isAcquired     = %s\n", (pF->isAcquired) ? "YES" : "NO");
    }
}

TEST( PcieServer_UnregisteredQuery, Finalize)
{
    NNT_EXPECT_RESULT_SUCCESS(nn::pcie::Finalize());
}
