﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs.h>
#include <nn/nn_Assert.h>

nn::Result OpenAndLogRomfs(const char* path)
{
    nn::fs::FileHandle handle;
    char buffer[1024];
    size_t readSize;

    auto result = nn::fs::OpenFile(&handle, path, nn::fs::OpenMode_Read);
    if (result.IsSuccess())
    {
        NN_RESULT_DO(nn::fs::ReadFile(&readSize, handle, 0, buffer, sizeof(buffer), nn::fs::ReadOption()));
        nn::fs::CloseFile(handle);

        buffer[readSize] = '\0';
        NN_LOG("%s: %s\n", path, buffer);;
    }
    else if (nn::fs::ResultPathNotFound::Includes(result))
    {
        NN_LOG("Not found: %s\n", path);
    }
    else
    {
        NN_LOG("Unknown error: %s\n", path);
    }
    NN_RESULT_SUCCESS;
}

void ReadRomfs()
{
    static const size_t MountRomCacheBufferSize = 4 * 1024;
    static char s_MountRomCacheBuffer[MountRomCacheBufferSize];

    size_t mountRomCacheUseSize = 0;
    auto result = nn::fs::QueryMountRomCacheSize(&mountRomCacheUseSize);
    NN_ASSERT(result.IsSuccess());
    NN_ASSERT_LESS_EQUAL(mountRomCacheUseSize, MountRomCacheBufferSize);

    nn::fs::MountRom("rom", s_MountRomCacheBuffer, MountRomCacheBufferSize);
    OpenAndLogRomfs("rom:/a.txt");
    OpenAndLogRomfs("rom:/b.txt");
    OpenAndLogRomfs("rom:/c/d.txt");
    OpenAndLogRomfs("rom:/c/e.txt");
    OpenAndLogRomfs("rom:/c/f.txt");
    OpenAndLogRomfs("rom:/g.txt");
    nn::fs::Unmount("rom");
}

