﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// kernelcalltest.cpp
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

const int TEST_ITERATIONS = 10000;

nn::os::Tick g_dontoptimizemebro; // prevents the loop from being potentially optimized out

void Test()
{
    //Get start time
    auto start = nn::os::GetSystemTick().ToTimeSpan().GetMicroSeconds();

    //Loop kernel call numerous times
    for(int i = 0; i < TEST_ITERATIONS; i++)
    {
        // sum to avoid caching
        g_dontoptimizemebro += nn::os::GetIdleTickCount();
    }

    //Get end time
    auto end = nn::os::GetSystemTick().ToTimeSpan().GetMicroSeconds();

    NN_LOG("##teamcity[buildStatisticValue key='us_for_%d_simple_kernel_calls' value='%d']\n", TEST_ITERATIONS, end - start);
    NN_LOG("##teamcity[buildStatisticValue key='us_simple_kernel_calls_avg' value='%f']\n", (double)(end - start) / (double)TEST_ITERATIONS);
    NN_UNUSED(g_dontoptimizemebro);
}

extern "C" void nnMain()
{
    Test();
}
