﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  MemoryAccess 検査機能
//---------------------------------------------------------------------------

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

namespace nnt { namespace os {
namespace detail {

//---------------------------------------------------------------------------

enum MemAttribute
{
    MemAttr_NonAccess        = 0,
    MemAttr_Normal_None,
    MemAttr_Normal_ReadOnly,
    MemAttr_Normal_ReadWrite,
    MemAttr_Normal_NonAccess_Locked,
    MemAttr_Alias_ReadWrite,
    MemAttr_Stack_ReadWrite,
};

//---------------------------------------------------------------------------
//  指定された address のページ属性が MemTest 通りかどうかを判定する。
//  MemTest に合致した場合は true を、そうでなければ false を返す。
bool MemoryAccessTest(uintptr_t address, MemAttribute attr) NN_NOEXCEPT;


//---------------------------------------------------------------------------

}   // namespace detail
}}  // namespace nnt::os

