﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/base/testBase_Exit.h>

#include <nn/fs.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>

#include <nn/fs/fs_ResultHandler.h>
#include <nn/fs/fs_Result.public.h>
#include <nn/fs/fs_SystemSaveData.h>
#include <nn/fs/fs_SystemSaveDataPrivate.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/fs/fs_UserAccountSystemSaveData.h>
#include <nn/fs/fs_SaveDataTransferVersion2.h>
#include <nn/fssystem/fs_AllocatorUtility.h>
#include <nn/fssystem/fs_Utility.h>

#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/olsc_ApiForPrivate.h>
#include <nn/olsc/olsc_ApiForSystemService.h>
#include <nn/olsc/olsc_RemoteStorageController.h>
#include <nn/olsc/olsc_TransferTaskListController.h>
#include <nn/olsc/srv/olsc_InternalTypes.h>
#include <nn/olsc/srv/olsc_Util.h>
#include <nn/olsc/srv/database/olsc_SaveDataArchiveInfoCache.h>
#include <nn/olsc/srv/util/olsc_Account.h>
#include <nn/olsc/srv/util/olsc_MountManager.h>
#include <nn/olsc/srv/util/olsc_SaveData.h>
#include <nn/olsc/srv/transfer/olsc_ComponentFileUpload.h>
#include <nn/olsc/srv/transfer/olsc_ComponentFileDownload.h>
#include <nn/olsc/srv/transfer/olsc_SaveDataArchiveUpload.h>
#include <nn/olsc/srv/transfer/olsc_SaveDataArchiveDownload.h>
#include <nn/olsc/srv/transfer/olsc_PolicyInfoDownload.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_FormatString.h>

#include <nn/account/account_Api.h>
#include <nn/account/account_ApiForSystemServices.h>
#include <nn/account/account_ApiForApplications.h>
#include <nn/account/account_ApiForAdministrators.h>

#include <nnt/fsUtil/testFs_util.h>
#include <nnt/fsUtil/testFs_util_function.h>
#include <nn/crypto/crypto_Md5Generator.h>
#include <nn/util/util_Base64.h>

#include "testOlsc_Util.h"
#include "testOlsc_SaveDataUtil.h"



using namespace nn;
using namespace nn::olsc;
using namespace nn::olsc::srv;

namespace {

    const size_t WorkBufferSize        = 4 * 1024 * 1024;

    const nn::Bit64 PolicySampleAppId = 0x010002500cc20000ULL;
    const uint32_t PolicySampleNgVersion = 0x00000;
    const uint32_t PolicySampleOkVersion = 0x00001;
}

TEST(GetPolicyInfo, Simple)
{

    auto workBuffer = nnt::fs::util::AllocateBuffer(WorkBufferSize);

    ApplicationId appId = { PolicySampleAppId };
    nn::util::optional<fs::SaveDataInfo> infoSrc;

    auto curl = curl_easy_init();

    olsc::srv::PolicyInfo policy;

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    NNT_OLSC_EXPECT_RESULT_SUCCESS(nn::olsc::srv::transfer::GetPolicyInfo(&policy, appId, PolicySampleNgVersion, curl, workBuffer.get(), WorkBufferSize, nullptr));
    EXPECT_TRUE(policy.type == olsc::srv::PolicyType::AllNg);
#endif
    NNT_OLSC_EXPECT_RESULT_SUCCESS(nn::olsc::srv::transfer::GetPolicyInfo(&policy, appId, PolicySampleOkVersion, curl, workBuffer.get(), WorkBufferSize, nullptr));
    EXPECT_TRUE(policy.type == olsc::srv::PolicyType::AllOk);
}

extern "C" void nnMain()
{
    int     argc = nn::os::GetHostArgc();
    char**  argv = nn::os::GetHostArgv();

    nnt::olsc::Initialize();

    ::testing::InitGoogleTest(&argc, argv);
    auto ret = RUN_ALL_TESTS();

    nnt::olsc::Finalize();

    nnt::Exit(ret);
}
