﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/result/testResult_Assert.h>

#include <nn/fs.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/olsc_ApiForPrivate.h>
#include <nn/olsc/olsc_ApiForSystemService.h>
#include <nn/olsc/olsc_DaemonController.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/account/account_Api.h>
#include <nn/account/account_ApiForSystemServices.h>
#include <nn/account/account_ApiForApplications.h>

#include "testOlsc_Stopwatch.h"

using namespace nn;
using namespace nn::olsc;

namespace {

    class OlscDaemonControllerTest : public testing::Test
    {
    protected:
        virtual void SetUp()
        {
        }

        virtual void TearDown()
        {
        }

        static void SetUpTestCase()
        {
            account::InitializeForSystemService();
        }

        static void TearDownTestCase()
        {
        }
    private:

    };

    account::Uid GetFirstUserId() NN_NOEXCEPT
    {
        int userCount;
        NN_ABORT_UNLESS_RESULT_SUCCESS(account::GetUserCount(&userCount));
        NN_ABORT_UNLESS(userCount > 0);

        account::Uid uid;
        int listCount;
        NN_ABORT_UNLESS_RESULT_SUCCESS(account::ListAllUsers(&listCount, &uid, 1));
        return uid;
    }
}

TEST_F(OlscDaemonControllerTest, AutoUpload)
{
    auto uid = GetFirstUserId();
    olsc::DeleteAllApplicationSetting(uid);

    auto dc = OpenDaemonController();

    const int MaxAppCount = 2000;
    for (int i = 0; i < MaxAppCount; ++i)
    {
        ApplicationId appId = { static_cast<Bit64>(i) };
        NN_LOG("App[%d]: %016llx\n", i, appId);

        {
            nnt::olsc::Stopwatch s(true, "Get(NotSet):");
            EXPECT_FALSE(dc.IsAutoUploadEnabled(uid, appId));
        }
        {
            nnt::olsc::Stopwatch s(true, "Add(new):");
            dc.SetAutoUploadEnabled(uid, appId, true);
        }
        {
            nnt::olsc::Stopwatch s(true, "Get:");
            EXPECT_TRUE(dc.IsAutoUploadEnabled(uid, appId));
        }
        {
            nnt::olsc::Stopwatch s(true, "Add(Update):");
            dc.SetAutoUploadEnabled(uid, appId, false);
        }
        {
            nnt::olsc::Stopwatch s(true, "Get:");
            EXPECT_FALSE(dc.IsAutoUploadEnabled(uid, appId));
        }
    }
}

TEST_F(OlscDaemonControllerTest, StopAutonomyTaskExecution)
{
    // とりあえずビルドが通ることだけ確認

    auto dc = OpenDaemonController();

    auto stopper = dc.StopAutonomyTaskExecution();

}
