﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

extern "C" void nninitStartup() {}
extern "C" void nndiagStartup() {}
extern "C" void nnMain() {}
extern "C" void __cxa_pure_virtual() {}

extern "C" void* malloc(size_t size)
{
    NN_UNUSED(size);
    return nullptr;
}

extern "C" void free(void* p)
{
    NN_UNUSED(p);
}

extern "C" void* calloc(size_t num, size_t size)
{
    NN_UNUSED(num);
    NN_UNUSED(size);
    return nullptr;
}

extern "C" void* realloc(void* p, size_t newSize)
{
    NN_UNUSED(p);
    NN_UNUSED(newSize);
    return nullptr;
}


extern "C" void* aligned_alloc(size_t alignment, size_t size)
{
    NN_UNUSED(alignment);
    NN_UNUSED(size);
    return nullptr;
}

extern "C" size_t malloc_usable_size(void* p)
{
    NN_UNUSED(p);
    return 0;
}
