﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nsd/nsd_ApiForTest.h>
#include "./testNsd_Constant.h"

#include <nn/nsd/nsd_ApiForMiddleware.h>
#include <nn/nsd/nsd_ApiForMenu.h>
#include <nn/nsd/nsd_ApiForNasService.h>
#include <nn/nsd/nsd_ApiForNasServicePrivate.h>

#include <nn/nn_SdkLog.h>

using namespace nn::nsd;


//
// 実機で lp1 のデフォルト設定であることを想定
//
#if !defined(NN_BUILD_CONFIG_OS_WIN)

TEST(NsdTest_ForLp1Test, MenuApi)
{
    nn::nsd::EnvironmentIdentifier env;
    nn::nsd::GetEnvironmentIdentifier(&env);
    EXPECT_STREQ("lp1", env.value);
}

TEST(NsdTest_ForLp1Test, Resolve)
{
    {
        const nn::nsd::Fqdn in = {"hoge-%.com"};
        nn::nsd::Fqdn out;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::Resolve(&out, in));
        EXPECT_STREQ("hoge-lp1.com", out.value);
    }

    {
        const nn::nsd::Fqdn in = {"hoge-%.com"};
        nn::nsd::Fqdn out;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::ResolveEx(&out, in));
        EXPECT_STREQ("hoge-lp1.com", out.value);
    }

    // baas: lp1 FQDN を入れてそのままでてくるか
    {
        nn::nsd::Fqdn out;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::ResolveEx(&out, nnt::nsd::constant::Lp1.baasFqdn));
        EXPECT_STREQ(nnt::nsd::constant::Lp1.baasFqdn.value, out.value);
    }
}

// Nas Fqdn の直接取得
TEST(NsdTest_ForLp1Test, NasFqdn1)
{
    {
        nn::nsd::Fqdn fqdn;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasApiFqdn(&fqdn));
        EXPECT_STREQ(nnt::nsd::constant::Lp1.nasApiFqdn.value, fqdn.value);
    }
    {
        nn::nsd::Fqdn fqdn;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasRequestFqdn(&fqdn));
        EXPECT_STREQ(nnt::nsd::constant::Lp1.nasRequestFqdn.value, fqdn.value);
    }
}

// Nas Fqdn の Resolve
TEST(NsdTest_ForLp1Test, NasFqdn2)
{
    // lp1 nasApiFqdn を入れてそのままでてくるか
    {
        nn::nsd::Fqdn out;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::ResolveEx(&out, nnt::nsd::constant::Lp1.nasApiFqdn));
        EXPECT_STREQ(nnt::nsd::constant::Lp1.nasApiFqdn.value, out.value);
    }

    // lp1 nasRequestFqdn を入れてそのままでてくるか
    {
        nn::nsd::Fqdn out;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::ResolveEx(&out, nnt::nsd::constant::Lp1.nasRequestFqdn));
        EXPECT_STREQ(nnt::nsd::constant::Lp1.nasRequestFqdn.value, out.value);
    }
}

// NasService の取得
TEST(NsdTest_ForLp1Test, NasService)
{
    // ビルトイン設定を取得して lp1 のものと等しいか確認
    {
        nn::nsd::NasServiceSetting setting;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasServiceSetting(&setting, nn::nsd::NasServiceNameOfNxAccount));
        EXPECT_STREQ(nnt::nsd::constant::Lp1.nasServiceSettingOfNxAccount.redirectUri.value, setting.redirectUri.value);
        EXPECT_EQ(nnt::nsd::constant::Lp1.nasServiceSettingOfNxAccount.clientId, setting.clientId);
    }
    {
        nn::nsd::NasServiceSetting setting;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasServiceSetting(&setting, nn::nsd::NasServiceNameOfNxShop));
        EXPECT_STREQ(nnt::nsd::constant::Lp1.nasServiceSettingOfNxShop.redirectUri.value, setting.redirectUri.value);
        EXPECT_EQ(nnt::nsd::constant::Lp1.nasServiceSettingOfNxShop.clientId, setting.clientId);
    }
    {
        nn::nsd::NasServiceSetting setting;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasServiceSetting(&setting, nn::nsd::NasServiceNameOfNxFriends));
        EXPECT_STREQ(nnt::nsd::constant::Lp1.nasServiceSettingOfNxFriends.redirectUri.value, setting.redirectUri.value);
        EXPECT_EQ(nnt::nsd::constant::Lp1.nasServiceSettingOfNxFriends.clientId, setting.clientId);
    }
    {
        nn::nsd::NasServiceSetting setting;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasServiceSetting(&setting, nn::nsd::NasServiceNameOfNxELicense));
        EXPECT_STREQ(nnt::nsd::constant::Lp1.nasServiceSettingOfNxELicense.redirectUri.value, setting.redirectUri.value);
        EXPECT_EQ(nnt::nsd::constant::Lp1.nasServiceSettingOfNxELicense.clientId, setting.clientId);
    }
}

#endif

