@echo off

set CONFIG_TESTS_ROOT=%CD%\..\..\..\..\..
set CONFIG_PLATFORM=NXFP2-a64
set CONFIG_BUILD_TYPE=Develop
set CONFIG_INTERMEDIATE=%CONFIG_TESTS_ROOT%\Outputs\AnyCPU\Tests\testNs_NupSimple\%CONFIG_BUILD_TYPE%
set CONFIG_DEVICE_ID_FILE=%CONFIG_INTERMEDIATE%\GetDeviceId.Result.txt

set CONFIG_INTERMEDIATE_CUP=%CONFIG_TESTS_ROOT%\Outputs\AnyCPU\Tests\testNs_CupSimple\%CONFIG_BUILD_TYPE%
set CONFIG_CUP_FILE=%CONFIG_INTERMEDIATE_CUP%\CupConfig_v1.txt

set CONFIG_TITLE_ID=01001a500005e03f
set CONFIG_PROGRAM_ID=01001a500005e030



rem Proxy I
set NN_TEST_SCRIPT_PROXY_CONFIGURATION=""

if "%1" == "did" goto testForScriptOnGetDeviceId
if "%1" == "delivery" goto testForScriptOnSetupWeatherDelivery
if "%1" == "upload" goto testForScriptOnUploadNsp
if "%1" == "cup" goto testForScriptOnCupNsp
if "%1" == "key" goto testForScriptOnMetaKey
if "%1" == "stopWeather" goto testForScriptOnStopWeather
goto help


:testForScriptOnGetDeviceId
setlocal

powershell -Version 2.0 -ExecutionPolicy Unrestricted .\GetDeviceId.ps1 -Platform %CONFIG_PLATFORM% -BuildType %CONFIG_BUILD_TYPE% -OutputDeviceIdFile %CONFIG_DEVICE_ID_FILE%

endlocal
goto end

:testForScriptOnSetupWeatherDelivery
setlocal

powershell -Version 2.0 -ExecutionPolicy Unrestricted .\SetupWetherDelivery.ps1 -Platform %CONFIG_PLATFORM% -BuildType %CONFIG_BUILD_TYPE% -InputDeviceIdFile %CONFIG_DEVICE_ID_FILE% -TitleId %CONFIG_TITLE_ID% -TitleVersion 1 -DeliveryId 49

endlocal
goto end

:testForScriptOnStopWeather
setlocal

powershell -Version 2.0 -ExecutionPolicy Unrestricted .\StopWetherDelivery.ps1 -Platform %CONFIG_PLATFORM% -BuildType %CONFIG_BUILD_TYPE% -DeliveryId 49

endlocal
goto end

:testForScriptOnUploadNsp
setlocal

powershell -Version 2.0 -ExecutionPolicy Unrestricted .\SetupNupContents.ps1 -Platform %CONFIG_PLATFORM% -IntermediateDirectory %CONFIG_INTERMEDIATE% -UpdateId %CONFIG_TITLE_ID% -ProgramId %CONFIG_PROGRAM_ID%

endlocal
goto end

:testForScriptOnCupNsp
setlocal

powershell -Version 2.0 -ExecutionPolicy Unrestricted .\SetupCupContents.ps1 -Platform %CONFIG_PLATFORM% -IntermediateDirectory %CONFIG_INTERMEDIATE_CUP%
powershell -Version 2.0 -ExecutionPolicy Unrestricted .\WriteGameCard.ps1 -Platform %CONFIG_PLATFORM% -BuildType %CONFIG_BUILD_TYPE% -InputCupConfigFile %CONFIG_CUP_FILE%

endlocal
goto end

:testForScriptOnMetaKey
setlocal

rem set CONTENT_META_KEY="01001a500005e03f:0:SystemUpdate/01001a500005e030:0:SystemProgram"
rem powershell -Version 2.0 -ExecutionPolicy Unrestricted .\MakeVerifyProperties.ps1 -IntermediateDirectory %CONFIG_INTERMEDIATE% -ContentMetaKeys %CONTENT_META_KEY%

set SYSTEM_UPDATE_META=%CONFIG_INTERMEDIATE%\%CONFIG_TITLE_ID%_v0.nmeta
powershell -Version 2.0 -ExecutionPolicy Unrestricted .\MakeVerifyProperties.ps1 -IntermediateDirectory %CONFIG_INTERMEDIATE% -SourceSystemUpdateMetaFile %SYSTEM_UPDATE_META%

endlocal
goto end

rem --------------------------------------------------------------------------
:help

    echo $ executeScriptTest.bat [target]
    echo [target] is following keyword are accepted:
    echo     'did' : testing with execute the GetDeviceId.ps1.
    echo     'delivery' : testing with execute the SetupWetherDelivery.ps1.

:end
