﻿<#
    .SYNOPSIS
        Private platform utilities module

    .DESCRIPTION
        This file defines functions for private operations
#>

# 基本パス関連 ( 全部文字列型らしい [string] )
$MyScriptPath          = $MyInvocation.MyCommand.Path
$MyScriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyScriptPath)

# SDK ROOT検索
function Find-NintendoSdkRootPath
{
    $callerPath = $MyInvocation.ScriptName
    $dirName    = [System.IO.Path]::GetDirectoryName($callerPath)
    while ( $dirName )
    {
        if ( Test-Path "${dirName}\NintendoSdkRootMark" )
        {
            return $dirName
        }
        $dirName = [System.IO.Path]::GetDirectoryName($dirName)
    }
    $message = "NintendoSdkRootMark not found"
    throw New-Object "System.IO.FileNotFoundException" $message
}

# アーキテクチャシンボル取得
function Get-ArchitectSignature( [string]$defPlatform )
{
    $defPlatforms32 = @( "NX-NXFP2-a32", "NXFP2-a32", "NX32" )
    $defPlatforms64 = @( "NX-NXFP2-a64", "NXFP2-a64", "NX64" )

    if ( $defPlatforms64 -contains ${defPlatform} )
    {
        return [string] "aarch64.lp64"
    }
    elseif ( $defPlatforms32 -contains ${defPlatform} )
    {
        return [string] "aarch32.ilp32"
    }
    throw "Unavailable platfrom were specified : ${Platform}."
}

# プラットフォームシンボル補正
function Resolve-PlatformConstants( [string]$Platform )
{
    $defPlatforms32 = @( "NX-NXFP2-a32", "NXFP2-a32", "NX32" )
    $defPlatforms64 = @( "NX-NXFP2-a64", "NXFP2-a64", "NX64" )

    if ( $defPlatforms64 -contains ${Platform} )
    {
        return [System.String] $defPlatforms64[0]
    }
    elseif ( $defPlatforms32 -contains ${Platform} )
    {
        return [System.String] $defPlatforms32[0]
    }
    $message = "Unavailable platfrom were specified : ${Platform}."
    throw New-Object "System.IO.FileNotFoundException" $message
}

# -----------------------------------------------------------------------
# cURL 実行ファイル検索
#  git のインストールディレクト以下の curl を当てにする。
# -----------------------------------------------------------------------
function Get-CurlExec
{
    try
    {
        $intallLocation = Get-SoftwareRegistryValue "Microsoft\Windows\CurrentVersion\Uninstall\Git_is1" InstallLocation

        $curl = @(Get-ChildItem -Path $intallLocation -Filter "curl.exe" -Recurse)
        if(-not $curl)
        {
            throw "Could not find the cURL executor."
        }

        [string] $defCurlExec = $curl[0].FullName
        [string] $defCurlExec = "`"${defCurlExec}`""
        Invoke-Expression "& ${defCurlExec} --version 2>&1" | Out-Null
        if ( $LastExitCode -ne 0 )
        {
            throw "Could not find the cURL executor`n    -> ${defCurlExec}."
        }
        return ${defCurlExec}
    }
    catch [System.IO.FileNotFoundException]
    {
        throw New-Object "System.IO.FileNotFoundException" ("git not installed", $_.Exception)
    }
}

Export-ModuleMember -Function *
