﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <cstdlib>
#include <cstring>

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/ns/ns_Result.h>
#include <nn/util/util_ScopeExit.h>
#include "libraries/testNs_CommandOptions.h"

#define LOG_OUT( ... )  NN_LOG( "[ShopRuntimeAssistants] " __VA_ARGS__ )

namespace testns {

    //!--------------------------------------------------------------------------------------
    //! 配列要素数算出.
    //!--------------------------------------------------------------------------------------
    template< typename TYPE, size_t SIZE >
    inline static unsigned CountOf( const TYPE( & )[ SIZE ] ) {
        return SIZE;
    }

    //!--------------------------------------------------------------------------------------
    //! Result出力.
    //!--------------------------------------------------------------------------------------
    void LogoutResultValue( const nn::Result& result, const char* const pTitle ) NN_NOEXCEPT;

    //!--------------------------------------------------------------------------------------
    //! コマンドラインオプションを数値で取得
    //!--------------------------------------------------------------------------------------
    template< typename TypeOfValue >
    inline static const TypeOfValue GetOptionAsInteger( const char* pOptionKey, const TypeOfValue defaultValue = TypeOfValue() ) NN_NOEXCEPT
    {
        // strtoull::radix=0 でprefix依存
        char pValue[ 64 ] = "";
        return ( testns::QueryCommandLineOptions( pOptionKey, sizeof( pValue ), pValue ) )
            ? static_cast< TypeOfValue >( std::strtoull( pValue, nullptr, 0 ) )
            : defaultValue;
    }

} // namespace testns
