﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/ae.h>

#include <nn/la/la_NifmToNetConnectArgumentsReader.h>
#include <nn/la/la_AppletToNifmArgumentsWriter.h>
#include <nn/la/la_CommonArgumentsReader.h>

#include <nn/nifm/nifm_ResultPrivate.h>

#include "../Common/nifm_TestUtility.h"

void LibraryAppletNetConnectMain(const nn::ae::LibraryAppletSelfInfo& info) NN_NOEXCEPT
{
    NN_LOG("===== DummyNetConnect Start =====\n");

    // 第1ストレージ
    {
        nn::la::CommonArgumentsReader commonArgumentsReader;

        ASSERT_TRUE(commonArgumentsReader.TryPopFromInChannel());

        NN_LOG("commonArguments\n");
        NN_LOG("\tlaVersion = %u\n", commonArgumentsReader.GetLaVersion());
        NN_LOG("\tcolorIndex = %d\n", commonArgumentsReader.GetColorIndex());
        NN_LOG("\tisPlayStartupSound = %s\n", commonArgumentsReader.IsPlayStartupSound() ? "true" : "false");
    }

    // 第2ストレージ
    nn::la::netconnect::BootMode bootMode = nn::la::netconnect::BootMode_Default;
    {
        nn::applet::StorageHandle storageHandle;
        if (nn::ae::TryPopFromInChannel(&storageHandle))
        {
            NNT_ASSERT_RESULT_SUCCESS(nn::applet::ReadFromStorage(storageHandle, 0, &bootMode, sizeof(bootMode)));
            nn::applet::ReleaseStorage(storageHandle);
            NN_LOG("\n");
            NN_LOG("bootMode = %d\n", static_cast<int>(bootMode));
        }
    }

    // 第3ストレージ
    if (bootMode == nn::la::netconnect::BootMode_FromNifm)
    {
        nn::la::NifmToNetConnectArgumentsReader netConnectArgumentsReader;

        ASSERT_TRUE(netConnectArgumentsReader.TryPopFromInChannel());

        nn::Result result = netConnectArgumentsReader.GetNetworkConnectionResult();
        nn::util::Uuid uuid = netConnectArgumentsReader.GetNetworkProfileId();
        char uuidString[nn::util::Uuid::StringSize] = {};

        ASSERT_TRUE(result <= nn::nifm::ResultDhcpFailedOrPassphraseWrong() || result <= nn::nifm::ResultNetworkNotFound());

        NN_LOG("\n");
        NN_LOG("netConnectArguments\n");
        NN_LOG("\tresult = %d-%d\n", result.GetModule(), result.GetDescription());
        NN_LOG("\tid = %s\n", uuid.ToString(uuidString, nn::util::Uuid::StringSize));
    }

    // 疎通確認成功を応答
    // NetConnect アプレットが lsys::Terminator::setReturnParam 経由で返す値を模擬
    // 0:接続成功, 1:もどる, 2:あとで, 3:サービスディスカバリ
    nn::applet::StorageHandle storageHandle;
    int32_t retValue = 0;
    NNT_ASSERT_RESULT_SUCCESS(nn::applet::CreateStorage(&storageHandle, sizeof(retValue)));
    NNT_ASSERT_RESULT_SUCCESS(nn::applet::WriteToStorage(storageHandle, 0, &retValue, sizeof(retValue)));
    nn::ae::PushToOutChannel(storageHandle);
}

extern "C" void nninitStartup()
{
    // 本テストはアプレット向け desc を利用しており、アプレット向けのリソース制限が適用されます。
    // ここでは、デフォルトの nninitStartup() のデフォルトメモリアロケータのサイズが
    // アプレットで利用できるサイズ上限を超えているため、自前で nninitStartup() を用意しています。
}

extern "C" void nnMain()
{
    nn::ae::InvokeLibraryAppletMain(LibraryAppletNetConnectMain);
}

