﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nn_Log.h>

#include <nn/nifm/detail/core/accessPoint/nifm_WirelessAccessPoint.h>
#include <nn/nifm/detail/core/accessPoint/nifm_AccessPointList.h>

#include "../Common/nifm_TestUtility.h"


TEST(AccessPointListCase, Sort)
{
    static const size_t PassivelyScannedAccessPointListBufferSize = 32 * 1024;
    nn::nifm::detail::AccessPointList<nn::nifm::detail::ExpHeap<PassivelyScannedAccessPointListBufferSize>> passivelyScannedAccessPointList;

    NN_UNUSED(passivelyScannedAccessPointList);


    struct RssiAndLinkLevel
    {
        int rssi;
        nn::nifm::LinkLevel linkLevel;
    };

    RssiAndLinkLevel rssiAndLinkLevel[] =
    {
        { -90, nn::nifm::LinkLevel_0 },
        { -86, nn::nifm::LinkLevel_0 }, // 2.4 GHz
        { -86, nn::nifm::LinkLevel_1 }, // 5 GHz
        { -73, nn::nifm::LinkLevel_1 }, // 2.4 GHz
        { -74, nn::nifm::LinkLevel_2 }, // 5 GHz
        { -61, nn::nifm::LinkLevel_2 }, // 2.4 GHz
        { -62, nn::nifm::LinkLevel_3 }, // 5 GHz
    };

    RssiAndLinkLevel sortedRssiAndLinkLevel[] =
    {
        { -62, nn::nifm::LinkLevel_3 }, // 5 GHz
        { -61, nn::nifm::LinkLevel_2 }, // 2.4 GHz
        { -74, nn::nifm::LinkLevel_2 }, // 5 GHz
        { -73, nn::nifm::LinkLevel_1 }, // 2.4 GHz
        { -86, nn::nifm::LinkLevel_1 }, // 5 GHz
        { -86, nn::nifm::LinkLevel_0 }, // 2.4 GHz
        { -90, nn::nifm::LinkLevel_0 },
    };

    NN_STATIC_ASSERT(NN_ARRAY_SIZE(rssiAndLinkLevel) == NN_ARRAY_SIZE(sortedRssiAndLinkLevel));

    const nn::nifm::detail::WirelessAccessPoint* pWirelessAccessPointList[NN_ARRAY_SIZE(rssiAndLinkLevel)];

    for (int i = 0; i < NN_ARRAY_SIZE(rssiAndLinkLevel); ++i)
    {
        nn::nifm::detail::WirelessAccessPoint wirelessAccessPoint(nullptr);
        wirelessAccessPoint.SetWepAuthenticationAndEncryption(nn::nifm::Authentication_Open, nn::nifm::Encryption_None);
        wirelessAccessPoint.SetRssi(rssiAndLinkLevel[i].rssi);
        wirelessAccessPoint.SetLinkLevel(rssiAndLinkLevel[i].linkLevel);

        // push_back される
        passivelyScannedAccessPointList.CreateAndAdd<nn::nifm::detail::WirelessAccessPoint>(wirelessAccessPoint);

        pWirelessAccessPointList[i] = static_cast<const nn::nifm::detail::WirelessAccessPoint*>(&*(--passivelyScannedAccessPointList.end()));
    }

    // sort
    std::sort(&pWirelessAccessPointList[0], &pWirelessAccessPointList[NN_ARRAY_SIZE(rssiAndLinkLevel)],
        [](const nn::nifm::detail::WirelessAccessPoint* pLhs, const nn::nifm::detail::WirelessAccessPoint* pRhs) { return pLhs->GetPriority() < pRhs->GetPriority(); });

    for (int i = 0; i < NN_ARRAY_SIZE(sortedRssiAndLinkLevel); ++i)
    {
        EXPECT_EQ(sortedRssiAndLinkLevel[i].rssi, pWirelessAccessPointList[i]->GetRssi());
        EXPECT_EQ(sortedRssiAndLinkLevel[i].linkLevel, pWirelessAccessPointList[i]->GetLinkLevel());
    }
}
